using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

namespace CBIOSServerEventLog_Sample
{
    public partial class FormLPM : Form
    {
        const short EVENT_CATEGORY_SERVER = 0;
        const short EVENT_CATEGORY_LPM = 1;
        const int EVENT_MESS_SERVER_STARTED       = 100;
        const int EVENT_MESS_SERVER_STOPPED       = 101;
        const int EVENT_MESS_LPM_LOCKED_LICENCE   = 200;
        const int EVENT_MESS_LPM_UNLOCKED_LICENCE = 201;
        
        private void FillEntry(EventLogEntry entry)
        {
            if (entry.CategoryNumber != EVENT_CATEGORY_LPM) return;
            // cbios_adm.h :
            //typedef struct
            //{
            //  DWORD dwHandle;               //0-param
            //  DWORD dwBoxName;              //1
            //  WORD  wAppID;                 //2
            //  <!-BOOL  isLicenceLocked;-!>
            //  DWORD/*time_t*/ Timeout;      //3
            //  char  szUserComputerName[32]; //4
            //  char  szUserAppFileName[32];  //5
            //} NETCBIOS_CONNECTION_REC;
            dataGridView_CBIOSServerLPM.Rows.Add(
                entry.ReplacementStrings[0], //Handle
                entry.ReplacementStrings[4], //UserComputerName
                entry.ReplacementStrings[5], //UserAppFileName
                entry.ReplacementStrings[1], //BoxName
                entry.ReplacementStrings[2], //AppId
                entry.ReplacementStrings[6], //Free licences
                entry.TimeGenerated);
        }
        private void FillEntryActive(EventLogEntry entry)
        {
            if (entry.InstanceId == EVENT_MESS_LPM_LOCKED_LICENCE)
                FillEntry(entry);
            else
                if (entry.InstanceId == EVENT_MESS_LPM_UNLOCKED_LICENCE)
                    DelEntry(entry);
        }
        private void DelEntry(EventLogEntry entry)
        {
            if (entry.CategoryNumber != EVENT_CATEGORY_LPM) return;
            string handle = entry.ReplacementStrings[0];
            foreach (DataGridViewRow row in dataGridView_CBIOSServerLPM.Rows)
            {
                if (handle == row.Cells[0].Value.ToString())
                {
                    dataGridView_CBIOSServerLPM.Rows.Remove(row);
                    break;
                }
            }
        }

        private void EventlogSet()
        {
            try
            {
                eventLog_CBIOSServer.Log = eventLog_CBIOSServer.Source;
                eventLog_CBIOSServer.EnableRaisingEvents = true;
                this.eventLog_CBIOSServer.EntryWritten += new EntryWrittenEventHandler(this.eventLog_CBIOSServer_EntryWritten);
            }
            catch (System.Security.SecurityException exc)
            {
                MessageBox.Show(exc.Source + " : " + exc.Message);
                throw;
            }
            catch
            {
                MessageBox.Show("Run first CBIOS Server to register eventlog source: " + eventLog_CBIOSServer.Source  + "."
                    + Environment.NewLine + "If it isn't enough :-) restart service EVENTLOG or reboot your computer.",
                    this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
                throw;
            }
        }

        //Must be executed on CBIOS-server computer
        public FormLPM()
        {
            InitializeComponent();
            this.MinimumSize = this.Size;

            EventlogSet();

            // cbios_adm.h :
            //typedef struct
            //{
            //  DWORD dwHandle;
            //  DWORD dwBoxName;
            //  WORD  wAppID;
            //  BOOL  isLicenceLocked;
            //  DWORD/*time_t*/ Timeout;
            //  char  szUserComputerName[32];
            //  char  szUserAppFileName[32];
            //} NETCBIOS_CONNECTION_REC;
            dataGridView_CBIOSServerLPM.Columns.Add("Handle", "Handle");
            dataGridView_CBIOSServerLPM.Columns.Add("UserComputerName", "User");
            dataGridView_CBIOSServerLPM.Columns.Add("UserAppFileName", "Application");
            dataGridView_CBIOSServerLPM.Columns.Add("BoxName", "Box name");
            dataGridView_CBIOSServerLPM.Columns.Add("AppId", "App Id");
            dataGridView_CBIOSServerLPM.Columns.Add("Licences", "Free licences");
            dataGridView_CBIOSServerLPM.Columns.Add("DataTime", "Data & Time");
            EventLogEntryCollection eventLogColl_CBIOSServer = eventLog_CBIOSServer.Entries;
            int entryCBIOSServerStarted = 0;
            for (int i = eventLogColl_CBIOSServer.Count - 1; i >= 0; i--)
            {
                EventLogEntry eventLogEntry = eventLogColl_CBIOSServer[i];
                if (eventLogEntry.CategoryNumber == EVENT_CATEGORY_SERVER)
                    if (eventLogEntry.InstanceId == EVENT_MESS_SERVER_STARTED)
                    {
                        entryCBIOSServerStarted = i + 1;
                        break;
                    }
                    else
                        if (eventLogEntry.InstanceId == EVENT_MESS_SERVER_STOPPED)
                        {
                            if (i != eventLogColl_CBIOSServer.Count - 1)
                                MessageBox.Show("Corrupted database of EventLog!", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
                            entryCBIOSServerStarted = i + 1;
                            break;
                        }
            }
            for (int i = entryCBIOSServerStarted; i < eventLogColl_CBIOSServer.Count; i++)
                FillEntryActive(eventLogColl_CBIOSServer[i]);
        }

        private void eventLog_CBIOSServer_EntryWritten(object sender, System.Diagnostics.EntryWrittenEventArgs e)
        {
            switch (e.Entry.InstanceId)
            {
                case EVENT_MESS_SERVER_STARTED:
                case EVENT_MESS_SERVER_STOPPED:
                    MessageBox.Show(e.Entry.Message);
                    dataGridView_CBIOSServerLPM.Rows.Clear();
                break;
                case EVENT_MESS_LPM_LOCKED_LICENCE:
                    FillEntry(e.Entry);
                break;
                case EVENT_MESS_LPM_UNLOCKED_LICENCE:
                    DelEntry(e.Entry);
                break;
                default:
                    MessageBox.Show("EventId: "+e.Entry.InstanceId+Environment.NewLine+
                        e.Entry.Message);
                break;
            }
        }
    }
}