using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CBIOS4NET;

namespace LPM_Simulation_Sample
{
    public partial class FormLPMSimulation : Form
    {
        const uint NetLicCount = 10;
        CBIOS4NET.NetworkCBManager CBIOSManager = null;
        List<Cryptobox> listCBs = new List<Cryptobox>();
        const string upw_passw = "demo";
        const string apw_passw = "admin";
        private AppLicences backup_licences = null;
        public FormLPMSimulation()
        {
            InitializeComponent();
            this.MinimumSize = this.Size;
        }

        private void button_Start_Click(object sender, EventArgs e)
        {
            button_Start.Enabled = false;
            textBox_CurrStatus.Text = "Connecting...";
            textBox_FreeLicences.Text = textBox_LockedLicences.Text = "";
            this.Refresh();
            try
            {
                CBIOSManager = new CBIOS4NET.NetworkCBManager();
                CBIOSManager.Connect(textBox_server.Text, ushort.Parse(textBox_server_port.Text));
                textBox_CurrStatus.Text = "Connected. Setting licences...";
                this.Refresh();
                Cryptobox box = CBIOSManager.OpenByAppId(ushort.Parse(textBox_AppId.Text));
                box.Login(CryptoboxLoginType.User, upw_passw);
                backup_licences = box.GetApplicationLicences();
                box.SetApplicationLicences(new AppLicences(backup_licences.LocalLicences, NetLicCount), apw_passw);
                textBox_FreeLicences.Text = box.CheckApplicationLicences().NetLicences.ToString();
                textBox_CurrStatus.Text = "Suspending " + timer_SimulationLockLicences.Interval / 1000 + " sec";
                this.Refresh();
                box.Logout();
                timer_SimulationLockLicences.Enabled = true;
            }
            catch (CBIOS4NET.CBIOSException exc)
            {
                MessageBox.Show(exc.Message);
                button_Start.Enabled = true;
            }
            button_Stop.Enabled = true;
        }

        private void button_Stop_Click(object sender, EventArgs e)
        {
            button_Stop.Enabled = false;
            try
            {
                if (listCBs.Count > 0)
                {
                    timer_SimulationLockLicences.Enabled = false;
                    timer_SimulationReleaseLicences.Enabled = false;
                    textBox_CurrStatus.Text = "Release all licences...";
                    textBox_LockedLicences.Text = textBox_FreeLicences.Text = "";
                    this.Refresh();
                    foreach (Cryptobox cb in listCBs)
                    {
                        cb.UnlockLicence();
                        cb.Dispose();
                    }
                    listCBs.Clear();
                }
                if (null != CBIOSManager)
                {
                    if (backup_licences != null)
                    {
                        Cryptobox box = CBIOSManager.OpenByAppId(ushort.Parse(textBox_AppId.Text));
                        box.Login(CryptoboxLoginType.User, upw_passw);
                        box.SetApplicationLicences(backup_licences, apw_passw);
                        box.Logout();
                        backup_licences = null;
                    }
                    if (CBIOSManager.IsConnected)
                        CBIOSManager.Disconnect();
                    CBIOSManager = null;
                }
                textBox_CurrStatus.Text = "Disconnected";
                this.Refresh();
            }
            catch (CBIOS4NET.CBIOSException exc)
            {
                MessageBox.Show(exc.Message);
                button_Stop.Enabled = true;
            }
            button_Start.Enabled = true;
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            try
            {
                textBox_CurrStatus.Text = "Locking licence...";
                this.Refresh();
                Cryptobox box = CBIOSManager.OpenByAppId(ushort.Parse(textBox_AppId.Text));
                listCBs.Add(box);
                box.Login(CryptoboxLoginType.User, upw_passw);
                box.LockLicence();
                textBox_LockedLicences.Text = listCBs.Count.ToString();
                textBox_FreeLicences.Text = box.CheckApplicationLicences().NetLicences.ToString();
                textBox_CurrStatus.Text = "Suspending " + timer_SimulationLockLicences.Interval / 1000 + " sec";
                this.Refresh();
                box.Logout();
            }
            catch (CBIOS4NET.CBIOSException exc)
            {
                timer_SimulationLockLicences.Enabled = false;
                if (exc.ErrorCode == CBIOSErrorCode.CBIOSERR_NO_FREE_LICENCE)
                {
                    timer_SimulationReleaseLicences.Enabled = true;
                    textBox_CurrStatus.Text = "Suspending " + timer_SimulationLockLicences.Interval / 1000 + " sec for release licences";
                    this.Refresh();
                }
                else MessageBox.Show(exc.Message);
            }
        }

        private void timer_SimulationReleaseLicences_Tick(object sender, EventArgs e)
        {
            if (listCBs.Count > 0)
                try
                {
                    textBox_CurrStatus.Text = "Release licence...";
                    this.Refresh();
                    listCBs[0].UnlockLicence();
                    listCBs[0].Login(CryptoboxLoginType.User, upw_passw);
                    textBox_FreeLicences.Text = listCBs[0].CheckApplicationLicences().NetLicences.ToString();
                    listCBs[0].Logout();
                    listCBs[0].Dispose(); // -> call CBIOS_Close now
                    listCBs.RemoveAt(0);
                    textBox_LockedLicences.Text = listCBs.Count.ToString();
                    textBox_CurrStatus.Text = "Suspending " + timer_SimulationReleaseLicences.Interval / 1000 + " sec";
                    this.Refresh();
                }
                catch (CBIOS4NET.CBIOSException exc)
                {
                    MessageBox.Show(exc.Message);
                    button_Stop.Enabled = true;
                    return;
                }
            else
            {
                timer_SimulationReleaseLicences.Enabled = false;
                textBox_CurrStatus.Text = "Suspending " + timer_SimulationLockLicences.Interval / 1000 + " sec";
                timer_SimulationLockLicences.Enabled = true;
            }
            this.Refresh();
        }

        private void FormLPMSimulation_FormClosing(object sender, FormClosingEventArgs e)
        {
            button_Stop_Click(null, null);
        }

        private void trackBar1_Scroll(object sender, EventArgs e)
        {
            timer_SimulationLockLicences.Interval = trackBar1.Value * 1000;
        }

        private void trackBar2_Scroll(object sender, EventArgs e)
        {
            timer_SimulationReleaseLicences.Interval = trackBar2.Value * 1000;
        }
    }
}