/*****************************************************************************
  Copyright:   : MARX CryptoTech LP
  Project      : CBIOS: CRYPTO-BOX Input/Output System API
  Created      : 25Feb2003                                    
  Tools        : MSVC++ 6.0 SP5                               
  Description  : CBIOS NET administration API definitions
******************************************************************************
  VER         DATE        WHO   DETAIL                        
******************************************************************************
  1.00         1Mar2004   VS    Initial version
*****************************************************************************/

#ifndef _CBIOS_ADM_H_
#define _CBIOS_ADM_H_

#ifdef WIN32
#include <windows.h>
#else
#include "winconst.h"
#endif //WIN32
#include <time.h>

#define NETCBIOS_MAX_HANDLES 256

#pragma pack(1)

typedef struct
{
  DWORD dwHandle;
  DWORD dwBoxName;
  WORD  wAppID;
  BOOL  isLicenceLocked;
  DWORD/*time_t*/ Timeout;
  char  szUserComputerName[32];
  char  szUserAppFileName[32];
} NETCBIOS_CONNECTION_REC;


#pragma pack()

#ifdef __cplusplus
extern "C"
{
#endif

DWORD WINAPI CBIOS_GetSessionList(NETCBIOS_CONNECTION_REC* pConnections, DWORD* pdwRecCount);
DWORD WINAPI CBIOS_RestartServer(BYTE bSrvPass[0x10]);
DWORD WINAPI CBIOS_SetPort(USHORT usPort, BYTE bSrvPass[0x10]);
DWORD WINAPI CBIOS_StopServer(BYTE bSrvPass[0x10]);
DWORD WINAPI CBIOS_SetConnTimeout(LONG lTimeoutSec, BYTE bSrvPass[0x10]);
DWORD WINAPI CBIOS_GetConnTimeout(LONG *plTimeoutSec, BYTE bSrvPass[0x10]);
DWORD WINAPI CBIOS_SetKeepAliveParams(DWORD dwScanRateMSec, LONG lTimeoutSec, BYTE bSrvPass[0x10]);
DWORD WINAPI CBIOS_GetKeepAliveParams(DWORD *pdwScanRateMSec, LONG *plTimeoutSec, BYTE bSrvPass[0x10]);
DWORD WINAPI CBIOS_SetServerPasswd(BYTE bOldPass[0x10], BYTE bNewPass[0x10]);
DWORD WINAPI CBIOS_CheckServerPasswd(BYTE bSrvPass[0x10]);

#ifdef __cplusplus
}
#endif

#endif _CBIOS_H_
