/*****************************************************************************
Copyright:   : MARX(R) CryptoTech LP
Project      : CBIOS: net admin sample
Created      : 24Feb2006                                    
Tools        : MSVC++ 6.0 SP5                               
Description  : CBIOS NET ADMIN API SAMPLE
******************************************************************************
VER         DATE        WHO   DETAIL                        
******************************************************************************
1.0         17Dec2005   OK                                  
*****************************************************************************/

#include <windows.h>
#include <stdio.h>

#ifndef LINUX
#include <conio.h>
#else // LINUX
#include <unistd.h>
int getch(void)
{
    int i, j;
    i = getchar();
    while (j != 10)
        j = getchar();
    return i;
}
#endif // LINUX

#include "cbios.h"
#include "cbios_adm.h"

char szAddr[32];
BYTE bSrvPass []    = "admin\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"; 
BYTE bSrvPassNew [] = "admin_new\x00\x00\x00\x00\x00\x00\x00"; 

// -------------------------------------------------------------------------------
void PrintError(char* szErrorText)
{
# ifndef LINUX
  HANDLE hStdHandle;
  hStdHandle = GetStdHandle(STD_OUTPUT_HANDLE);
  SetConsoleTextAttribute(hStdHandle, FOREGROUND_RED);
# endif // LINUX

  if (szErrorText == NULL) 
    printf("[ERROR]"); 
  else 
    printf("[ERROR: %s]",szErrorText);

# ifndef LINUX
  Beep(200,30);
  SetConsoleTextAttribute(hStdHandle, FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_BLUE);
# endif // LINUX
}

void PrintErrorCode(DWORD dwError)
{
  char szTemp[100];
  
# ifndef LINUX
  HANDLE hStdHandle;
  hStdHandle = GetStdHandle(STD_OUTPUT_HANDLE);
  if (dwError != 0)
    SetConsoleTextAttribute(hStdHandle, FOREGROUND_RED);
# endif // LINUX

  printf("\t");

  CBIOS_ErrorToText(dwError, szTemp);
  if (dwError == 0)
    printf("[%s]", szTemp);
  else
    PrintError(szTemp);
  printf("\n");

# ifndef LINUX
  SetConsoleTextAttribute(hStdHandle, FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_BLUE);
# endif // LINUX
}

// -------------------------------------------------------------------------------
void GetConnections()
{
  DWORD dwRet;
  NETCBIOS_CONNECTION_REC Connections[NETCBIOS_MAX_HANDLES];
  DWORD dwCount = NETCBIOS_MAX_HANDLES;
  NETCBIOS_CONNECTION_REC *pConnection = NULL;
  DWORD i;

  printf(":: CBIOS_GetSessionList()");
  dwRet = CBIOS_GetSessionList(Connections, &dwCount);
  PrintErrorCode(dwRet);
  if (dwRet == 0)
  {
    printf("  connections number: %d\n\n", dwCount);
    for (i=0; i<dwCount; i++)
    {
      pConnection = &Connections[i];
      printf("  %d. Session handle: %d, BoxName (S/N): 0x%08lX\n",
        i + 1, pConnection->dwHandle, pConnection->dwBoxName);    
      printf("     SmarxOS(r) application opened (ID): %d, Licence locked: %s\n",
        pConnection->wAppID, pConnection->isLicenceLocked ? "true" : "false");    
      printf("     Client computer: %s, Client application: %s\n",
        pConnection->szUserComputerName, pConnection->szUserAppFileName);    
      printf("     Time to 'by timeout' disconnection (sec): %d\n\n", pConnection->Timeout);    
    }
  }
}

// -------------------------------------------------------------------------------
void ConnParams()
{
  DWORD dwRet;
  LONG lTimeoutSec, lTimeoutSecOld;
  DWORD dwScanRateMSec, dwScanRateMSecOld;

  printf("\n===== Connection timeout =====\n\n");
 
  printf(":: CBIOS_GetConnTimeout ('%s')", bSrvPass);
  dwRet = CBIOS_GetConnTimeout(&lTimeoutSecOld, bSrvPass);
  PrintErrorCode(dwRet);
  if (dwRet == 0)
    printf("  timeout: %d\n", lTimeoutSecOld);

  lTimeoutSec = lTimeoutSecOld + 10;
  printf(":: CBIOS_SetConnTimeout (%d, '%s')", lTimeoutSec, bSrvPass);
  dwRet = CBIOS_SetConnTimeout(lTimeoutSec, bSrvPass);
  PrintErrorCode(dwRet);

  printf(":: CBIOS_GetConnTimeout ('%s')", bSrvPass);
  dwRet = CBIOS_GetConnTimeout(&lTimeoutSec, bSrvPass);
  PrintErrorCode(dwRet);
  if (dwRet == 0)
    printf("  timeout: %d\n", lTimeoutSec);

  printf(":: CBIOS_SetConnTimeout (%d, '%s')", lTimeoutSecOld, bSrvPass);
  dwRet = CBIOS_SetConnTimeout(lTimeoutSecOld, bSrvPass);
  PrintErrorCode(dwRet);

  printf(":: CBIOS_GetConnTimeout ('%s')", bSrvPass);
  dwRet = CBIOS_GetConnTimeout(&lTimeoutSec, bSrvPass);
  PrintErrorCode(dwRet);
  if (dwRet == 0)
    printf("  timeout: %d\n", lTimeoutSec);

  printf("\n===== Keep alive parameters =====\n\n");

  printf(":: CBIOS_GetKeepAliveParams ('%s')", bSrvPass);
  dwRet = CBIOS_GetKeepAliveParams(&dwScanRateMSecOld, &lTimeoutSecOld, bSrvPass);
  PrintErrorCode(dwRet);
  if (dwRet == 0)
    printf("  scan rate: %d, timeout: %d\n", dwScanRateMSecOld, lTimeoutSecOld);

  dwScanRateMSec = dwScanRateMSecOld + 1000;
  lTimeoutSec = lTimeoutSecOld + 10;
  printf(":: CBIOS_SetKeepAliveParams (%d, %d, '%s')", dwScanRateMSec, lTimeoutSec, bSrvPass);
  dwRet = CBIOS_SetKeepAliveParams(dwScanRateMSec, lTimeoutSec, bSrvPass);
  PrintErrorCode(dwRet);

  printf(":: CBIOS_GetKeepAliveParams ('%s')", bSrvPass);
  dwRet = CBIOS_GetKeepAliveParams(&dwScanRateMSec, &lTimeoutSec, bSrvPass);
  PrintErrorCode(dwRet);
  if (dwRet == 0)
    printf("  scan rate: %d, timeout: %d\n", dwScanRateMSec, lTimeoutSec);

  printf(":: CBIOS_SetKeepAliveParams (%d, %d, '%s')", dwScanRateMSecOld, lTimeoutSecOld, bSrvPass);
  dwRet = CBIOS_SetKeepAliveParams(dwScanRateMSecOld, lTimeoutSecOld, bSrvPass);
  PrintErrorCode(dwRet);

  printf(":: CBIOS_GetKeepAliveParams ('%s')", bSrvPass);
  dwRet = CBIOS_GetKeepAliveParams(&dwScanRateMSec, &lTimeoutSec, bSrvPass);
  PrintErrorCode(dwRet);
  if (dwRet == 0)
    printf("  scan rate: %d, timeout: %d\n", dwScanRateMSec, lTimeoutSec);
}

// -------------------------------------------------------------------------------
void ServerPasswd() 
{
  DWORD dwRet;

  printf(":: CBIOS_CheckServerPasswd ('%s')", bSrvPass);
  dwRet = CBIOS_CheckServerPasswd(bSrvPass);
  PrintErrorCode(dwRet);

  if (dwRet == 0)
  {
    printf(":: CBIOS_SetServerPasswd (old: '%s', new: '%s')", bSrvPass, bSrvPassNew);
    dwRet = CBIOS_SetServerPasswd(bSrvPass, bSrvPassNew);
    PrintErrorCode(dwRet);

    printf(":: CBIOS_CheckServerPasswd ('%s')", bSrvPassNew);
    dwRet = CBIOS_CheckServerPasswd(bSrvPassNew);
    PrintErrorCode(dwRet);

    printf(":: CBIOS_SetServerPasswd (old: '%s', new: '%s')", bSrvPassNew, bSrvPass);
    dwRet = CBIOS_SetServerPasswd(bSrvPassNew, bSrvPass);
    PrintErrorCode(dwRet);
  }
}

// -------------------------------------------------------------------------------
void ChangePort()
{
  DWORD dwRet;
  USHORT usPort;

  usPort = 8766;
  printf(":: CBIOS_SetPort (%d, '%s')", usPort, bSrvPass);
  dwRet = CBIOS_SetPort(usPort, bSrvPass);
  PrintErrorCode(dwRet);

  // Server restarts automatically on new port, reconnection is needed
  if (dwRet == 0)
  {
	  printf(":: CBIOS_Disconnect ()\n");
    dwRet = CBIOS_Disconnect();

    printf(":: CBIOS_Connect (%s:%d)", szAddr, usPort);
    dwRet = CBIOS_Connect(szAddr, usPort);
    PrintErrorCode(dwRet);

    usPort = 8765;
    printf(":: CBIOS_SetPort (%d, '%s')", usPort, bSrvPass);
    dwRet = CBIOS_SetPort(usPort, bSrvPass);
    PrintErrorCode(dwRet);

	  printf(":: CBIOS_Disconnect ()\n");
    dwRet = CBIOS_Disconnect();

    printf(":: CBIOS_Connect (%s:%d)", szAddr, usPort);
    dwRet = CBIOS_Connect(szAddr, usPort);
    PrintErrorCode(dwRet);
  }
}

// -------------------------------------------------------------------------------
void RestartServer()
{
  DWORD dwRet;

  printf(":: CBIOS_RestartServer ('%s')", bSrvPass);
  dwRet = CBIOS_RestartServer(bSrvPass);
  PrintErrorCode(dwRet);

  // No reconnection is needed
}

// -------------------------------------------------------------------------------
void StopServer()
{
  DWORD dwRet;

  printf(":: CBIOS_StopServer ('%s')", bSrvPass);
  dwRet = CBIOS_StopServer(bSrvPass);
  PrintErrorCode(dwRet);
  if (dwRet == 0)
    printf("== NOTE: Manual server restart is needed now\n");
  
  // NOTE: Manual server restart is needed
}

// -------------------------------------------------------------------------------
int main(int argc, char* argv[])
{
  DWORD dwRet;
  int n, i;
  char c[2] = {0};
  USHORT usPort;
  BOOL isStopped = FALSE;
 
  printf(":::: CBIOS NET ADMIN API SAMPLE PROGRAM ::::\n\n");

  if (argc < 2)
  {
    strcpy(szAddr, "127.0.0.1");
    usPort = 8765;
  }
  else
  {
    INT pos, len;
    pos = strcspn(argv[1], ":");
    len = (pos < sizeof(szAddr)-1) ? pos : sizeof(szAddr)-1;
    strncpy(szAddr, argv[1], len);
    szAddr[len] = 0;
    usPort = atoi(&argv[1][pos+1]);
  }
  
  printf(":: CBIOS_Connect (%s:%i)", szAddr, usPort);
  dwRet = CBIOS_Connect(szAddr, usPort);
  PrintErrorCode(dwRet);
  if (dwRet == 0)
  {
    printf("\n:: PRESS ANY KEY ::\n");
    getch();
    
    do
    {
      printf("\n");
      
      do
      {
        printf("\n====================================\n");
	      printf("1. Current connections\n");
        printf("2. Server password change test\n");
        printf("3. Connection parameters change test\n");
        printf("4. Server port change test\n");
        printf("5. Restart server\n");
        printf("6. Stop server (NOTE: you will need to start server manually after that)\n");
        printf("--------------------------------\n");
        printf("0. Exit\n");
        printf("\n");
        n = 6;
        do
        {
          printf("Select option (0..%i): ",n);
          c[0] = getch();
          printf("%c\n",c[0]);
          i = atoi(c);
          if ((i>=0)&&(i<=n))
            break;
        } while(1);
        
        // 0. Exit
        if (i == 0) break;
        
        switch (i)
        {
        case 1: // Current connections
          GetConnections();
          printf("\n:: PRESS ANY KEY ::\n");
          getch();
          break;
        case 2: // Server password change test
          ServerPasswd();
          printf("\n:: PRESS ANY KEY ::\n");
          getch();
          break;
        case 3: // Connection parameters change test
          ConnParams();
          printf("\n:: PRESS ANY KEY ::\n");
          getch();
          break;
        case 4: // Server port change test
          ChangePort();
          printf("\n:: PRESS ANY KEY ::\n");
          getch();
          break;
        case 5: // Restart server
          RestartServer();
          printf("\n:: PRESS ANY KEY ::\n");
          getch();
          break;
        case 6: // Stop server
          StopServer();
          isStopped = TRUE;
          printf("\n:: PRESS ANY KEY ::\n");
          getch();
          break;
        }
        
        printf("\n");
        
      } while (1);
      
      if (i != 1) break;
      
    } while (1);

    if (!isStopped)
    {
      printf(":: CBIOS_Disconnect");
      dwRet = CBIOS_Disconnect();
      PrintErrorCode(dwRet);
    }
  }
  
  printf("\n\nCopyright (c) MARX(r) CryptoTech LP\n");
        return 0;
}
